﻿// Listing 9-12

public class BinarySearchAlgorithm
{
   // Uwaga: To nie jest kompletny program.
   //
   //   Metoda binarySearch wykonuje operację szukania binarnego
   //   w tablicy ciągów znaków. W tablicy poszukiwany jest ciąg znaków
   //   podany w parametrze value. Jeżeli zostanie on znaleziony, 
   //   to zwracany jest indeks w tablicy. W przeciwnym wypadku zwracana
   //   jest wartość -1 oznaczająca, że szukanej wartości nie ma w tablicy.

   public static int binarySearch(String[] array, String value)
   {
      int first;       // Pierwszy element tablicy
      int last;        // Ostatni element tablicy
      int middle;      // Środkowy punkt wyszukiwania
      int position;    // Pozycja wartości szukanej
      boolean found;   // Znacznik

      // Ustalenie wartości początkowych.
      first = 0;
      last = array.length − 1;
      position = −1;
      found = false;

      // Poszukiwanie wartości parametru value.
      while (!found && first <= last)
      {
         // Wyznaczenie punktu środkowego
         middle = (first + last) / 2;

         // Jeżeli wartość została znaleziona w punkcie środkowym...
         if (array[middle].equals(value))
         {
            found = true;
            position = middle;
         }
         // albo jeżeli wartość znajduje się w dolnej części...
         else if (array[middle].compareTo(value) > 0)
            last = middle − 1;
         // w przeciwnym wypadku wartość znajduje się w górnej części...
         else
            first = middle + 1;
      }

      // Zwracamy indeks elementu albo wartość -1
      // jeżeli nie udało się znaleźć wartości szukanej.
      return position;
   }
}
